/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableCountry;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableSubdivision;
import com.ibm.hwmca.fw.rcs.conndata.PhoneInfo;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AddPhoneNumberBean
extends PanelBean
implements OutboundConnectivityConstants {
    private static final String TRACE_MASKT = "XRCSAPBT";
    private static final String TRACE_MASKF = "XRCSAPBF";
    private static final String TRACE_MASKD = "XRCSAPBD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-APhoBean");
    private List availCountries;
    private String countryCode = "";
    private Map availSubdivisions;
    private String subdivisionCode = "";
    private List availPredefinedNumbers;
    private PhoneInfo lastSelectedPredefinedInfo;
    private String m_sCountryRegion;
    private transient ValueDescriptor[] m_vdCountryRegion;
    private String m_sStateProvince;
    private transient ValueDescriptor[] m_vdStateProvince;
    private transient ItemDescriptor[][] m_idPredefinedNumbersTable;
    private transient ColumnDescriptor[] m_cdPredefinedNumbersTableStructure;
    private int[] m_iPredefinedNumbersTableSelection;
    private String m_sDialPrefix;
    private String m_sPhoneNumber;
    private String m_sComment;

    public AddPhoneNumberBean() {
        Trace.trace(TRACE_MASKT, "<> AddPhoneNumberBean()");
    }

    public ValueDescriptor[] getCountryRegionList() {
        return this.m_vdCountryRegion;
    }

    public void setCountryRegion(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setCountryRegion(" + s + ")");
        this.m_sCountryRegion = s;
        this.countryCode = this.getCountryCode(this.m_sCountryRegion);
        if (this.availSubdivisions.containsKey(this.countryCode)) {
            List subdivisions = (List)this.availSubdivisions.get(this.countryCode);
            DisplayableSubdivision subdivision = (DisplayableSubdivision)subdivisions.get(0);
            this.subdivisionCode = subdivision.getIsoCode();
        } else {
            this.subdivisionCode = "";
        }
        if (this.userTaskManager != null) {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("Source", "AddPhoneNumberPanel");
            request.setData("Command", "GetUpdate");
            request.setData("CountyCode", this.countryCode);
            request.setData("SubdivisionCode", this.subdivisionCode);
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- setCountryRegion()");
    }

    public String getCountryRegion() {
        return this.m_sCountryRegion;
    }

    public ValueDescriptor[] getStateProvinceList() {
        return this.m_vdStateProvince;
    }

    public void setStateProvince(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setStateProvince(" + s + ")");
        this.m_sStateProvince = s;
        this.subdivisionCode = this.getSubdivisionCode(this.countryCode, this.m_sStateProvince);
        if (this.userTaskManager != null) {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("Source", "AddPhoneNumberPanel");
            request.setData("Command", "GetUpdate");
            request.setData("CountyCode", this.countryCode);
            request.setData("SubdivisionCode", this.subdivisionCode);
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- setStateProvince()");
    }

    public String getStateProvince() {
        return this.m_sStateProvince;
    }

    public void setPredefinedNumbersTableSelection(int[] selected) throws IllegalUserDataException {
        if (selected != null && selected.length > 0) {
            Trace.trace(TRACE_MASKT, "-> setPredefinedNumbersTableSelection(" + selected[0] + ")");
        } else {
            Trace.trace(TRACE_MASKT, "-> setPredefinedNumbersTableSelection(none)");
        }
        this.m_iPredefinedNumbersTableSelection = selected;
        this.updateUTMElements(false);
        Trace.trace(TRACE_MASKT, "<- setPredefinedNumbersTableSelection()");
    }

    public int[] getPredefinedNumbersTableSelection() {
        return this.m_iPredefinedNumbersTableSelection;
    }

    public void setPredefinedNumbersTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idPredefinedNumbersTable[index] = items;
    }

    public ItemDescriptor[] getPredefinedNumbersTableRowAt(int index) {
        return this.m_idPredefinedNumbersTable[index];
    }

    public int getPredefinedNumbersTableRowCount() {
        return this.m_idPredefinedNumbersTable.length;
    }

    public int getPredefinedNumbersTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getPredefinedNumbersTableRowStructure() {
        return this.m_cdPredefinedNumbersTableStructure;
    }

    public void setDialPrefix(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> setDialPrefix(" + s + ")");
        this.m_sDialPrefix = s;
    }

    public String getDialPrefix() {
        return this.m_sDialPrefix;
    }

    public void setPhoneNumber(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setPhoneNumber(" + s + ")");
        this.m_sPhoneNumber = s.trim();
        LocalizableText errMsg = PhoneInfo.validatePhoneNumber(this.m_sPhoneNumber);
        if (errMsg != null) {
            throw new IllegalUserDataException(errMsg.toString());
        }
        Trace.trace(TRACE_MASKT, "<- setPhoneNumber()");
    }

    public String getPhoneNumber() {
        return this.m_sPhoneNumber;
    }

    public void setComment(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> setComment(" + s + ")");
        this.m_sComment = s.trim();
    }

    public String getComment() {
        return this.m_sComment;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> verifyChanges()");
        Trace.trace(TRACE_MASKT, "<- verifyChanges()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> load()");
        this.m_sCountryRegion = "";
        this.m_vdCountryRegion = new ValueDescriptor[0];
        this.m_sStateProvince = "";
        this.m_vdStateProvince = new ValueDescriptor[0];
        this.m_idPredefinedNumbersTable = new ItemDescriptor[0][0];
        this.m_cdPredefinedNumbersTableStructure = new ColumnDescriptor[0];
        this.m_iPredefinedNumbersTableSelection = new int[0];
        if (this.m_sDialPrefix == null) {
            this.m_sDialPrefix = "";
        }
        this.m_sPhoneNumber = "";
        this.m_sComment = "";
        Trace.trace(TRACE_MASKT, "<- load()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "-> save()");
        Trace.trace(TRACE_MASKT, "<- save()");
    }

    public void setAvailCountries(List countries) {
        Trace.trace(TRACE_MASKT, "<> setAvailCountries(" + countries.size() + ")");
        this.availCountries = countries;
    }

    public void setCountryCode(String code) {
        Trace.trace(TRACE_MASKT, "<> setCountryCode(" + code + ")");
        this.countryCode = code;
    }

    public void setAvailSubdivisions(Map subdivisions) {
        Trace.trace(TRACE_MASKT, "<> setAvailSubdivisions(" + subdivisions.size() + ")");
        this.availSubdivisions = subdivisions;
    }

    public void setSubdivisionCode(String code) {
        Trace.trace(TRACE_MASKT, "<> setSubdivisionCode(" + code + ")");
        this.subdivisionCode = code;
    }

    public void setAvailPredefinedNumbers(List numbers) {
        Trace.trace(TRACE_MASKT, "<> setAvailPredefinedNumbers(" + numbers.size() + ")");
        this.availPredefinedNumbers = numbers;
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        this.updateDataBeanInfo(true);
        this.updateUTMElements(false);
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void panelAction(TaskActionEvent event) {
        block10: {
            Trace.trace(TRACE_MASKT, "-> panelAction(" + event + ")");
            try {
                String element = event.getElementName();
                if (element.endsWith("SelectAsNumberButton")) {
                    int[] selections = this.getPredefinedNumbersTableSelection();
                    if (selections.length >= 1) {
                        PhoneInfo phoneInfo;
                        int selected = selections[0];
                        this.lastSelectedPredefinedInfo = phoneInfo = (PhoneInfo)this.availPredefinedNumbers.get(selected);
                        this.setPhoneNumber(phoneInfo.getPhoneNumber());
                        this.setComment(phoneInfo.getDescription());
                        this.updateUTMElements(true);
                    }
                    break block10;
                }
                if (element.endsWith("AddButton")) {
                    try {
                        this.userTaskManager.storeAllElements();
                        if (this.m_sPhoneNumber != null && !this.m_sPhoneNumber.equals("")) {
                            PanelTaskletRequest request = new PanelTaskletRequest();
                            request.setSource("AddPhoneNumberBean");
                            request.setData("Source", "AddPhoneNumberPanel");
                            request.setData("Command", "Commit");
                            request.setData("PhoneInfo", this.createNewPhoneInfo());
                            this.postTaskletRequest(request);
                        }
                        break block10;
                    }
                    catch (IllegalUserDataException iude) {}
                    break block10;
                }
                if (element.endsWith("CancelButton")) {
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource("AddPhoneNumberBean");
                    request.setData("Source", "AddPhoneNumberPanel");
                    request.setData("Command", "Cancel");
                    this.postTaskletRequest(request);
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown element");
                }
            }
            catch (RuntimeException rte) {
                new FrameworkLog(classLogInfo, 1941, rte).log();
                this.dispose();
            }
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void update(Object newData) {
        Trace.trace(TRACE_MASKT, "-> update");
        try {
            HashMap data = (HashMap)newData;
            String command = (String)data.get("Command");
            if (command == null) {
                command = "";
            }
            Trace.trace(TRACE_MASKF, "command=" + command);
            if (command.equals("")) {
                Trace.trace(TRACE_MASKF, "Unspecified command");
            } else if (command.equals("GetUpdate")) {
                this.availPredefinedNumbers = (List)data.get("PredefinedNumbers");
                this.updateDataBeanInfo(false);
                this.updateUTMElements(false);
            } else {
                Trace.trace(TRACE_MASKF, "Unknown command");
            }
        }
        catch (RuntimeException rte) {
            new FrameworkLog(classLogInfo, 1941, rte).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- update");
    }

    private void updateDataBeanInfo(boolean initialUpdate) {
        int i;
        Trace.trace(TRACE_MASKT, "-> updateDataBeanInfo(" + initialUpdate + ")");
        if (initialUpdate) {
            int numOfCountries = this.availCountries.size();
            if (numOfCountries > 0) {
                this.m_vdCountryRegion = new ValueDescriptor[numOfCountries];
                i = 0;
                while (i < numOfCountries) {
                    String desc = ((DisplayableCountry)this.availCountries.get(i)).getDescription();
                    this.m_vdCountryRegion[i] = new ValueDescriptor(null, desc);
                    ++i;
                }
                if (this.countryCode.equals("")) {
                    DisplayableCountry country = (DisplayableCountry)this.availCountries.get(0);
                    this.countryCode = country.getIsoCode();
                    this.m_sCountryRegion = country.getDescription();
                } else {
                    this.m_sCountryRegion = this.getCountryDesc(this.countryCode);
                }
            } else {
                this.countryCode = "";
                this.m_vdCountryRegion = new ValueDescriptor[0];
                this.m_sCountryRegion = "";
            }
        }
        if (this.availSubdivisions.containsKey(this.countryCode)) {
            List subdivisions = (List)this.availSubdivisions.get(this.countryCode);
            int numOfSubdivisions = subdivisions.size();
            this.m_vdStateProvince = new ValueDescriptor[numOfSubdivisions];
            int i2 = 0;
            while (i2 < numOfSubdivisions) {
                String desc = ((DisplayableSubdivision)subdivisions.get(i2)).getDescription();
                this.m_vdStateProvince[i2] = new ValueDescriptor(null, desc);
                ++i2;
            }
            if (this.subdivisionCode.equals("")) {
                DisplayableSubdivision subdivision = (DisplayableSubdivision)subdivisions.get(0);
                this.subdivisionCode = subdivision.getIsoCode();
                this.m_sStateProvince = subdivision.getDescription();
            } else {
                this.m_sStateProvince = this.getSubdivisionDesc(this.countryCode, this.subdivisionCode);
            }
        } else {
            this.subdivisionCode = "";
            this.m_vdStateProvince = new ValueDescriptor[0];
            this.m_sStateProvince = "";
        }
        int numOfPredefined = this.availPredefinedNumbers.size();
        this.m_idPredefinedNumbersTable = new ItemDescriptor[numOfPredefined][2];
        this.m_cdPredefinedNumbersTableStructure = new ColumnDescriptor[0];
        if (numOfPredefined > 0) {
            i = 0;
            while (i < numOfPredefined) {
                PhoneInfo predefined = (PhoneInfo)this.availPredefinedNumbers.get(i);
                String baseNumber = predefined.getPredefinedNumber();
                this.m_idPredefinedNumbersTable[i][0] = new ItemDescriptor(null, baseNumber);
                String desc = predefined.getDescription();
                this.m_idPredefinedNumbersTable[i][1] = new ItemDescriptor(null, desc);
                ++i;
            }
            this.m_iPredefinedNumbersTableSelection = new int[]{0};
        } else {
            this.m_iPredefinedNumbersTableSelection = new int[0];
        }
        Trace.trace(TRACE_MASKT, "<- updateDataBeanInfo()");
    }

    private void updateUTMElements(boolean isSelect) {
        Trace.trace(TRACE_MASKT, "-> updateUTMElements(" + isSelect + ")");
        if (this.userTaskManager != null) {
            String prefix = this.getMountPrefix();
            if (this.m_vdStateProvince.length >= 1) {
                this.userTaskManager.setEnabled(prefix + "StateProvince", true);
            } else {
                this.userTaskManager.setEnabled(prefix + "StateProvince", false);
            }
            if (this.m_iPredefinedNumbersTableSelection.length >= 1) {
                this.userTaskManager.setEnabled(prefix + "SelectAsNumberButton", true);
            } else {
                this.userTaskManager.setEnabled(prefix + "SelectAsNumberButton", false);
            }
            this.userTaskManager.refreshElement(prefix + "StateProvince");
            this.userTaskManager.refreshElement(prefix + "PredefinedNumbersTable");
            this.userTaskManager.refreshElement(prefix + "SelectAsNumberButton");
            if (isSelect) {
                this.userTaskManager.refreshElement(prefix + "PhoneNumber");
                this.userTaskManager.refreshElement(prefix + "Comment");
            }
        }
        Trace.trace(TRACE_MASKT, "<- updateUTMElements()");
    }

    private String getCountryCode(String desc) {
        String countryCode = "";
        Iterator iterator = this.availCountries.iterator();
        while (iterator.hasNext()) {
            DisplayableCountry country = (DisplayableCountry)iterator.next();
            if (!country.getDescription().equals(desc)) continue;
            countryCode = country.getIsoCode();
            break;
        }
        return countryCode;
    }

    private String getCountryDesc(String isoCode) {
        String countryDesc = "";
        Iterator iterator = this.availCountries.iterator();
        while (iterator.hasNext()) {
            DisplayableCountry country = (DisplayableCountry)iterator.next();
            if (!country.getIsoCode().equals(isoCode)) continue;
            countryDesc = country.getDescription();
            break;
        }
        return countryDesc;
    }

    private String getSubdivisionCode(String isoCtryCode, String desc) {
        String subdivisionCode = "";
        if (this.availSubdivisions.containsKey(isoCtryCode)) {
            List subdivisions = (List)this.availSubdivisions.get(isoCtryCode);
            Iterator iterator = subdivisions.iterator();
            while (iterator.hasNext()) {
                DisplayableSubdivision subdivision = (DisplayableSubdivision)iterator.next();
                if (!subdivision.getDescription().equals(desc)) continue;
                subdivisionCode = subdivision.getIsoCode();
                break;
            }
        }
        return subdivisionCode;
    }

    private String getSubdivisionDesc(String isoCtryCode, String isoSubCode) {
        String subdivisionDesc = "";
        if (this.availSubdivisions.containsKey(isoCtryCode)) {
            List subdivisions = (List)this.availSubdivisions.get(isoCtryCode);
            Iterator iterator = subdivisions.iterator();
            while (iterator.hasNext()) {
                DisplayableSubdivision subdivision = (DisplayableSubdivision)iterator.next();
                if (!subdivision.getIsoCode().equals(isoSubCode)) continue;
                subdivisionDesc = subdivision.getDescription();
                break;
            }
        }
        return subdivisionDesc;
    }

    private void validatePhoneNumber(String number) throws IllegalUserDataException {
        if (number == null || number.equals("")) {
            LocalizableText errMsg = new LocalizableText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", "FIELD_REQUIRED");
            throw new IllegalUserDataException(errMsg.toString());
        }
        int i = 0;
        while (i < number.length()) {
            char thisChar = number.charAt(i);
            if ("(-)0123456789".indexOf(thisChar) == -1) {
                Object[] subst = new Object[]{"'(-)0123456789'"};
                LocalizableText errMsg = new LocalizableText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", "FIELD_MAY_CONTAIN", subst);
                throw new IllegalUserDataException(errMsg.toString());
            }
            ++i;
        }
    }

    private PhoneInfo createNewPhoneInfo() {
        PhoneInfo newPhoneInfo = null;
        if (this.lastSelectedPredefinedInfo != null) {
            String number = this.m_sPhoneNumber.trim();
            String desc = this.m_sComment.trim();
            String baseNumber = this.lastSelectedPredefinedInfo.getPredefinedNumber();
            String countryCode = this.lastSelectedPredefinedInfo.getIsoCountryCode();
            String subdivCode = this.lastSelectedPredefinedInfo.getIsoSubdivisionCode();
            newPhoneInfo = new PhoneInfo(number, desc, countryCode, subdivCode, baseNumber);
        } else {
            String number = this.m_sPhoneNumber.trim();
            String desc = this.m_sComment.trim();
            String baseNumber = "";
            String countryCode = "";
            String subdivCode = "";
            newPhoneInfo = new PhoneInfo(number, desc, countryCode, subdivCode, baseNumber);
        }
        return newPhoneInfo;
    }
}

